% Section 6.7 Tutorial Example, Closed-loop system simulation with Separated strategy
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System
A = [    0         0    1.0000         0      0
         0   -0.1540   -0.0042    1.5400      0
         0    0.2490   -1.0000   -5.2000      0
    0.0386   -0.9960   -0.0003   -0.1170      0
         0    0.5000         0         0   -0.5]; 
     
B = [    0         0
   -3.7200   -0.1600
    1.6850   -5.6000
    0.1000         0
         0         0]; 
     
F = [    0
   -3.7200
    1.6850
    0.1000
         0];
     
D = [0 0;1 1;0 1;1 0;0 0];
C = [0 1 0 0 0;0 0 0 1 1;1 1 1 0 0];  

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% Uncertainty
Ap = [   0         0         0         0      0
         0   -0.1540   -0.0042    1.5400      0
         0    0.2490   -1.0000   -5.2000      0
    0.0386   -0.9960   -0.0003   -0.1170      0
         0    0.5000         0         0   -0.5];
     
Nc = eye(n);
Mc = 0.05*Ap;
Delta_A = Mc*Nc;

% Controller & observer gains
Cx = eye(n);
[K,gamma_c] = Step1_Controller_design(A,B,D,Nc,Mc,Cx)

Ce = eye(n+2*q);
[L,gamma_e] = Step2_Observer_design(A,F,C,D,Ce)

% Define global variables to store data
global tmp count ts ex1 ex2 ex3 ex4 ex5 ef ff
tmp = 0; count = 0; ts = []; ex1 = []; ex2 = []; ex3 = []; ex4 = []; ex5 = []; ef = []; ff = [];

% Initial conditon
x0 = [0.5 0 0.5 0 0];
hat_Xf0 = zeros(1,n+2*q);
xx0 = [x0 hat_Xf0];

% Simulation time span
t0 = 0;
tf = 50;
tspan = [t0 tf];

% Solve differential equation
[tt,sys] = ode45(@(t,xx) Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,L), tspan, xx0);
x1 = sys(:,1);
x2 = sys(:,2);
x3 = sys(:,3);
x4 = sys(:,4);
x5 = sys(:,5);
hat_f = sys(:,11);

% Draw figures
run('Draw_figures.m');